/*
 * Decompiled with CFR 0.152.
 */
package helmut;

import java.io.File;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class FileTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected Vector dateiliste = new Vector();
    protected Vector statusliste = new Vector();
    protected boolean nodata = true;

    public FileTableModel() {
        this(null);
    }

    public FileTableModel(File[] dateiliste) {
        this.dateiliste.removeAllElements();
        this.statusliste.removeAllElements();
        if (dateiliste == null || dateiliste.length == 0) {
            this.nodata = true;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            return;
        }
        int i = 0;
        while (i < dateiliste.length) {
            File temp = dateiliste[i];
            if (temp.getName().toUpperCase().endsWith("JPG") || temp.getName().toUpperCase().endsWith("JPEG")) {
                this.dateiliste.add(dateiliste[i]);
            }
            this.statusliste.add("");
            ++i;
        }
        this.nodata = false;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public void setDateiListe(File[] dateiliste) {
        this.dateiliste.removeAllElements();
        this.statusliste.removeAllElements();
        if (dateiliste == null || dateiliste.length == 0) {
            this.nodata = true;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            return;
        }
        int i = 0;
        while (i < dateiliste.length) {
            File temp = dateiliste[i];
            if (temp.getName().toUpperCase().endsWith("JPG") || temp.getName().toUpperCase().endsWith("JPEG")) {
                this.dateiliste.add(dateiliste[i]);
            }
            this.statusliste.add("");
            ++i;
        }
        this.nodata = false;
        this.fireTableDataChanged();
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        if (this.nodata) {
            return 0;
        }
        return this.dateiliste.size();
    }

    public int getColumnCount() {
        if (this.nodata) {
            return 1;
        }
        return 2;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.nodata) {
            return "Keine Dateien vorhanden";
        }
        File temp = (File)this.dateiliste.get(rowIndex);
        String spalte0 = temp.getAbsolutePath();
        String spalte1 = (String)this.statusliste.get(rowIndex);
        if (columnIndex == 0) {
            return spalte0;
        }
        if (columnIndex == 1) {
            return spalte1;
        }
        return null;
    }

    public String getColumnName(int column) {
        if (this.nodata) {
            return "Bislang keine Dateien konvertiert.";
        }
        if (column == 0) {
            return "Datei";
        }
        if (column == 1) {
            return "Status";
        }
        return "";
    }

    public void setDateiStatus(int nr, String status) {
        if (nr < 0 || nr >= this.statusliste.size()) {
            return;
        }
        this.statusliste.set(nr, status);
        this.fireTableDataChanged();
    }

    public void setDateiStatus(File f, String status) {
        int nr = this.getNrByFile(f);
        if (nr != -1) {
            this.setDateiStatus(nr, status);
        }
    }

    public int getNrByFile(File f) {
        int i = 0;
        while (i < this.dateiliste.size()) {
            File temp = (File)this.dateiliste.get(i);
            if (temp.getAbsolutePath().equals(f.getAbsolutePath())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

