/*
 * Decompiled with CFR 0.152.
 */
package helmut;

import Customize.SprachInterfaceDeutsch;
import Customize.SprachInterfaceEnglisch;
import Customize.Sprache;
import helmut.FileTableModel;
import helmut.KonverterWorker;
import helmut.MyTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import util.Util;

public class SimpleGui
extends JFrame {
    private static final long serialVersionUID = 1L;
    private File position = null;
    private final String VERSION = "0.1";
    static File KONFIGURATIONSFILE = new File("config.properties");
    private Properties properties = new Properties();
    private String sprache = "de";
    private Sprache aktSprache = new SprachInterfaceDeutsch();
    private String dateinamenpattern = "<Dateiname>.<Dateiendung>";
    private GridBagLayout meinLayout = new GridBagLayout();
    private String textziel = "C:\\";
    private String textquelle = "C:\\";
    private String workerpoolsize = "5";
    private MeinActionListener ma = new MeinActionListener();
    private JLabel labeltextziel = new JLabel();
    private JButton buttonziel = new JButton("Ziel");
    private JButton buttongo = new JButton("Go");
    private JTextField textqualitaet = new JTextField("85");
    private JLabel labelqualitaet = new JLabel("<html>Qualit\u00e4t (Wert von 0-100 ein):</html>");
    private JTextField textgroesse = new JTextField("600");
    private JLabel labelgroesse = new JLabel("<html>Gr\u00f6\u00dfe (Wert der l\u00e4ngsten Seite):</html>");
    private Object[] o = new Object[]{"<Name>_<Qualit\u00e4t>_<Gr\u00f6\u00dfe>.<Endung>", "<Name>_<Qualit\u00e4t>_<Gr\u00f6\u00dfe>.jpg", "<Name>_<Qualit\u00e4t>.jpg", "<Name>_<Gr\u00f6\u00dfe>.jpg", "<Name>.jpg", "<Name>.<Endung>"};
    private JComboBox combodateipattern = new JComboBox<Object>(this.o);
    private JLabel labeldateiname = new JLabel("<html>Name der konvertierten Datei:</html>");
    private JTextArea outp = new JTextArea();
    protected FileTableModel ftm = new FileTableModel();
    private JTable jt = new JTable(this.ftm);
    private JScrollPane jts = new JScrollPane(this.jt);
    private JScrollPane output = new JScrollPane(this.outp);
    public static Color BACKCOLOR = new Color(210, 240, 230);
    long starttime = 0L;
    static /* synthetic */ Class class$0;

    public SimpleGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.initGui();
    }

    private void initGui() {
        this.setTitle("JPG-Converter " + this.VERSION);
        this.getContentPane().setLayout(new BorderLayout());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jt.setDefaultRenderer(clazz, new MyTableCellRenderer());
        this.jt.setAutoResizeMode(4);
        this.jt.setEnabled(false);
        this.jts.getViewport().setOpaque(false);
        this.output.getViewport().setOpaque(false);
        JPanel top = new JPanel();
        top.setLayout(this.meinLayout);
        top.add(this.labeltextziel);
        top.add(this.labelqualitaet);
        top.add(this.labelgroesse);
        top.add(this.labeldateiname);
        top.add(this.textqualitaet);
        top.add(this.textgroesse);
        top.add(this.combodateipattern);
        top.add(this.buttonziel);
        top.add(this.buttongo);
        Util.easyConstraints(this.meinLayout, this.labeltextziel, 1, 1, 0, 0, 2.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.labelqualitaet, 1, 1, 0, 1, 2.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.labelgroesse, 1, 1, 0, 2, 2.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.labeldateiname, 1, 1, 0, 3, 2.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.buttonziel, 1, 1, 1, 0, 1.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.textqualitaet, 1, 1, 1, 1, 1.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.textgroesse, 1, 1, 1, 2, 1.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.combodateipattern, 2, 1, 1, 3, 1.0, 1.0);
        Util.easyConstraints(this.meinLayout, this.buttongo, 1, 3, 2, 0, 1.0, 1.0);
        Border blackborderline = BorderFactory.createLineBorder(Color.DARK_GRAY);
        top.setBorder(BorderFactory.createTitledBorder(blackborderline, "Eingabe"));
        this.jts.setBorder(BorderFactory.createTitledBorder(blackborderline, "Konvertierungsstatus"));
        this.output.setBorder(BorderFactory.createTitledBorder(blackborderline, "Log"));
        this.outp.setRows(3);
        this.outp.setEditable(false);
        this.outp.setOpaque(false);
        top.setBackground(BACKCOLOR);
        this.jts.setBackground(BACKCOLOR);
        this.output.setBackground(BACKCOLOR);
        this.getContentPane().add((Component)top, "North");
        this.getContentPane().add((Component)this.jts, "Center");
        this.getContentPane().add((Component)this.output, "South");
        this.buttonziel.addActionListener(this.ma);
        this.buttongo.addActionListener(this.ma);
        this.loadProperties();
        this.getContentPane().requestFocus();
        this.setSize(600, 600);
    }

    public void setTextZiel(String text) {
        this.textziel = text;
        String replacement = "&#8203;";
        int offset = 0;
        while (text.indexOf("\\", offset) >= offset) {
            int pos = text.indexOf("\\", offset);
            text = String.valueOf(text.substring(0, pos)) + replacement + text.substring(pos);
            offset = pos + replacement.length() + 1;
        }
        this.labeltextziel.setText("<html>" + text + "</html>");
    }

    public void doTheConversion() {
        float quali = 100.0f;
        int groesse = 100;
        try {
            quali = Integer.parseInt(this.textqualitaet.getText());
        }
        catch (Exception e) {
            this.outp.append("Da stimmt was mit der Qualit\u00f6t nicht. Bitte eine Zahl von 1 bis 100 eintragen!\n");
            return;
        }
        quali /= 100.0f;
        try {
            groesse = Integer.parseInt(this.textgroesse.getText());
        }
        catch (Exception e) {
            this.outp.append("Da stimmt was mit der Gr\u00f6\u00dfe nicht. Bitte eine Zahl eintragen!\n");
            return;
        }
        File ziel = new File(this.textziel);
        if (!ziel.exists()) {
            this.outp.append("Ziel nicht gefunden!\n");
            return;
        }
        this.saveProperties();
        this.outp.append("Eingaben ok, starte die Konvertierung...\n");
        JFileChooser jf = new JFileChooser(new File(this.textquelle));
        jf.setFileFilter(new MyFileFilter());
        jf.setFileSelectionMode(0);
        if (this.position != null) {
            jf.setCurrentDirectory(this.position);
        }
        jf.setMultiSelectionEnabled(true);
        this.starttime = System.currentTimeMillis();
        int returnVal = jf.showOpenDialog(this);
        if (returnVal == 0) {
            this.position = jf.getCurrentDirectory();
            this.textquelle = jf.getCurrentDirectory().getAbsolutePath();
            KonverterWorker.setFileNameHandler((String)this.combodateipattern.getSelectedItem());
            this.saveProperties();
            this.starttime = System.currentTimeMillis();
            File[] fArray = jf.getSelectedFiles();
            this.ftm.setDateiListe(fArray);
            int i = 0;
            while (i < fArray.length) {
                if (fArray[i].getName().toUpperCase().endsWith("JPG") || fArray[i].getName().toUpperCase().endsWith("JPEG")) {
                    this.ftm.setDateiStatus(fArray[i], "Warte auf Konvertierung");
                    KonverterWorker kw = new KonverterWorker(fArray[i], ziel, groesse, quali, this);
                    kw.start();
                }
                ++i;
            }
        } else {
            this.outp.append("Keine Aktion...");
        }
    }

    public void WorkFinished() {
        this.outp.append("Ben\u00f6tigte Zeit: " + (System.currentTimeMillis() - this.starttime) + "ms\n");
    }

    public void writeStatus(String text) {
        this.outp.append(String.valueOf(text) + "\n");
        this.outp.setCaretPosition(this.outp.getText().length());
    }

    public void waehleZiel() {
        File f = new File(this.textziel);
        JFileChooser jf = null;
        jf = f.exists() ? new JFileChooser(f) : new JFileChooser();
        jf.setMultiSelectionEnabled(false);
        jf.setFileSelectionMode(1);
        jf.setVisible(true);
        if (jf.showDialog(this, "\u00dcbernehmen") == 0) {
            this.setTextZiel(jf.getSelectedFile().getAbsolutePath());
        }
        this.saveProperties();
    }

    public void setToolTips() {
        this.labeltextziel.setToolTipText(this.aktSprache.TOOLTIP_LABEL_ZIEL);
        this.textqualitaet.setToolTipText(this.aktSprache.TOOLTIP_TEXTFIELD_QUALITAET);
        this.textgroesse.setToolTipText(this.aktSprache.TOOLTIP_TEXTFIELD_GROESSE);
        this.buttonziel.setToolTipText(this.aktSprache.TOOLTIP_BUTTON_ZIEL);
        this.buttongo.setToolTipText(this.aktSprache.TOOLTIP_BUTTON_GO);
        this.jts.setToolTipText(this.aktSprache.TOOLTIP_TABELLE);
        this.outp.setToolTipText(this.aktSprache.TOOLTIP_LOGAUSGABE);
        this.combodateipattern.setToolTipText(this.aktSprache.TOOLTIP_COMBO_DATEINAME);
    }

    public void saveProperties() {
        this.properties.setProperty("textziel", this.textziel);
        this.properties.setProperty("textquelle", this.textquelle);
        this.properties.setProperty("groesse", this.textgroesse.getText());
        this.properties.setProperty("qualitaet", this.textqualitaet.getText());
        this.properties.setProperty("sprache", this.sprache);
        this.properties.setProperty("dateinamentyp", (String)this.combodateipattern.getSelectedItem());
        this.properties.setProperty("poolsize", "" + KonverterWorker.getPool());
        try {
            FileOutputStream propOutFile = new FileOutputStream(KONFIGURATIONSFILE);
            if (this.properties == null) {
                return;
            }
            this.properties.store(propOutFile, "Bildkonverter Konfigurationsdatei");
        }
        catch (FileNotFoundException e) {
            System.err.println("Can\u2019t find configuration " + KONFIGURATIONSFILE + " : " + e);
        }
        catch (IOException e) {
            System.err.println("I/O failed. " + e);
        }
    }

    public void loadProperties() {
        this.properties = new Properties();
        try {
            FileInputStream propInFile = new FileInputStream(KONFIGURATIONSFILE);
            this.properties.load(propInFile);
        }
        catch (FileNotFoundException e1) {
            System.err.println("Can\u2019t find configuration " + KONFIGURATIONSFILE + " : " + e1);
        }
        catch (IOException e) {
            System.err.println("I/O failed. " + e);
        }
        String text1 = this.properties.getProperty("textquelle");
        if (text1 == null || text1.trim().length() == 0) {
            File f = new File("");
            text1 = f.getAbsolutePath();
        }
        this.textquelle = text1;
        String text2 = this.properties.getProperty("textziel");
        if (text2 == null || text2.trim().length() == 0) {
            File f = new File("");
            text2 = f.getAbsolutePath();
        }
        this.setTextZiel(text2);
        String qualitaet = this.properties.getProperty("qualitaet");
        if (qualitaet == null || qualitaet.trim().length() == 0) {
            qualitaet = "85";
        }
        this.textqualitaet.setText(qualitaet);
        String groesse = this.properties.getProperty("groesse");
        if (groesse == null || groesse.trim().length() == 0) {
            groesse = "600";
        }
        this.textgroesse.setText(groesse);
        int temppoolsize = 5;
        this.workerpoolsize = this.properties.getProperty("poolsize");
        if (this.workerpoolsize == null || this.workerpoolsize.trim().length() == 0) {
            this.workerpoolsize = "" + temppoolsize;
            KonverterWorker.setPool(temppoolsize);
        } else {
            try {
                temppoolsize = Integer.parseInt(this.workerpoolsize);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.workerpoolsize = "" + temppoolsize;
            KonverterWorker.setPool(temppoolsize);
        }
        this.sprache = this.sprache = this.properties.getProperty("sprache");
        if (this.sprache == null || this.sprache.trim().length() == 0) {
            this.sprache = "de";
        }
        if ("de_en".indexOf(this.sprache) == -1) {
            this.sprache = "de";
            this.aktSprache = new SprachInterfaceDeutsch();
        }
        if (this.sprache.equalsIgnoreCase("en")) {
            this.aktSprache = new SprachInterfaceEnglisch();
        }
        if (this.sprache.equalsIgnoreCase("de")) {
            this.aktSprache = new SprachInterfaceDeutsch();
        }
        this.dateinamenpattern = this.properties.getProperty("dateinamentyp");
        if (this.dateinamenpattern == null || this.dateinamenpattern.trim().length() == 0) {
            this.dateinamenpattern = "<Name>.<Endung>";
        }
        this.combodateipattern.setSelectedItem(this.dateinamenpattern);
        this.setToolTips();
    }

    public static void main(String[] args) {
        SimpleGui sg = new SimpleGui();
        sg.setDefaultCloseOperation(3);
        sg.setVisible(true);
    }

    public class MyFileFilter
    extends FileFilter {
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            if (pathname.getAbsolutePath().toUpperCase().endsWith("JPG")) {
                return true;
            }
            return pathname.getAbsolutePath().toUpperCase().endsWith("JPEG");
        }

        public String getDescription() {
            return "jpg, jpeg, JPG, JPEG - Bilddateien";
        }
    }

    class MeinActionListener
    implements ActionListener {
        MeinActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SimpleGui.this.buttongo) {
                SimpleGui.this.doTheConversion();
            } else if (e.getSource() == SimpleGui.this.buttonziel) {
                SimpleGui.this.waehleZiel();
            }
        }
    }
}

